using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace FS28BluetoothSlaveModeDemo
{
    public partial class FormPassword : Form
    {
        private bool m_bLogin = false;
        private string m_strLoginPassword;

        public FormPassword()
        {
            InitializeComponent();
        }

        public bool IsLogin
        {
            get { return m_bLogin; }
            set { m_bLogin = value; }
        }

        public string LoginPassword
        {
            get { return m_strLoginPassword; }
            set { m_strLoginPassword = value; }
        }

        private void FormPassword_Load(object sender, EventArgs e)
        {
            if (m_bLogin)
            {
                gbPassword.Text = "Change password";
                labelNewPassword.Visible = true;
                textNewPassword.Visible = true;
                labelConfirmPassword.Visible = true;
                textConfirmPassword.Visible = true;
                labelOldPassword.Text = "Old Password:";
            }
            textOldPassword.Focus();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (m_bLogin)
            {
                if (textOldPassword.Text.Length == 0 || textNewPassword.Text.Length == 0 || textConfirmPassword.Text.Length == 0)
                {
                    MessageBox.Show("Password can not be empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textOldPassword.Focus();
                    return;
                }
                if (textOldPassword.Text.CompareTo(m_strLoginPassword) != 0)
                {
                    MessageBox.Show("The old password is wrong!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textOldPassword.Focus();
                    return;
                }
                if (textNewPassword.Text.CompareTo(textConfirmPassword.Text) != 0)
                {
                    MessageBox.Show("The confirm password does not match the new password!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textNewPassword.Focus();
                    return;
                }
                if (textNewPassword.Text.CompareTo(m_strLoginPassword) == 0)
                {
                    MessageBox.Show("The new password is the same as old password!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textNewPassword.Focus();
                    return;
                }
                m_strLoginPassword = textNewPassword.Text;
            }
            else
            {
                if (textOldPassword.Text.Length == 0)
                {
                    MessageBox.Show("Password can not be empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textOldPassword.Focus();
                    return;
                }
                if (m_strLoginPassword.CompareTo(textOldPassword.Text) != 0)
                {
                    MessageBox.Show("The login password is wrong!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    textOldPassword.Focus();
                    return;    
                }
                m_bLogin = true;
            }
            this.btnOK.DialogResult = DialogResult.OK;
            this.DialogResult = DialogResult.OK;
            this.Close();
        }
    }
}